/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5558;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.mantle.client.model.data.IModelData;
import slimeknights.mantle.client.model.data.ModelDataMap;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.SmelteryControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.module.EntityMeltingModule;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.HeatingStructureMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.block.entity.tank.SmelteryTank;
import slimeknights.tconstruct.smeltery.menu.HeatingStructureContainerMenu;
import slimeknights.tconstruct.smeltery.network.StructureErrorPositionPacket;
import slimeknights.tconstruct.smeltery.network.StructureUpdatePacket;

public abstract class HeatingStructureBlockEntity
extends NameableBlockEntity
implements IMasterLogic,
ISmelteryTankHandler,
IRetexturedBlockEntity,
SidedStorageBlockEntity,
CustomRenderBoundingBoxBlockEntity {
    private static final String TAG_STRUCTURE = "structure";
    private static final String TAG_TANK = "tank";
    private static final String TAG_INVENTORY = "inventory";
    private static final String TAG_ERROR_POS = "errorPos";
    public static final class_5558<HeatingStructureBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.serverTick(level, pos, state);
    public static final class_5558<HeatingStructureBlockEntity> CLIENT_TICKER = (level, pos, state, self) -> self.clientTick(level, pos, state);
    private final HeatingStructureMultiblock<?> multiblock = this.createMultiblock();
    @Nullable
    private class_2338 errorPos;
    private int errorVisibleFor = 0;
    private boolean addedDrainListeners = false;
    @Nullable
    protected HeatingStructureMultiblock.StructureData structure;
    protected final SmelteryTank<HeatingStructureBlockEntity> tank = new SmelteryTank<HeatingStructureBlockEntity>(this);
    @Nullable
    private SlottedStorage<FluidVariant> fluidCapability;
    protected final MeltingModuleInventory meltingInventory = this.createMeltingInventory();
    protected final FuelModule fuelModule = new FuelModule((MantleBlockEntity)this, () -> this.structure != null ? this.structure.getTanks() : Collections.emptyList());
    protected int fuelRate = 1;
    protected final EntityMeltingModule entityModule = new EntityMeltingModule((MantleBlockEntity)this, this.tank, this::canMeltEntities, this::insertIntoInventory, () -> this.structure == null ? null : this.structure.getBounds());
    protected int tick = 0;
    private int expandCounter = 0;
    private boolean structureUpdateQueued = false;
    private boolean fluidUpdateQueued = false;
    private class_238 defaultBounds;
    @Nonnull
    private class_2248 texture = class_2246.field_10124;
    private final IModelData modelData = new ModelDataMap.Builder().withProperty(RetexturedHelper.BLOCK_PROPERTY).withProperty(IDisplayFluidListener.PROPERTY).build();
    private final List<WeakReference<IDisplayFluidListener>> fluidDisplayListeners = new ArrayList<WeakReference<IDisplayFluidListener>>();
    protected final Consumer<class_1799> dropItem = this::dropItem;

    protected HeatingStructureBlockEntity(class_2591<? extends HeatingStructureBlockEntity> type, class_2338 pos, class_2680 state, class_2561 name) {
        super(type, pos, state, name);
    }

    protected abstract HeatingStructureMultiblock<?> createMultiblock();

    protected abstract MeltingModuleInventory createMeltingInventory();

    protected abstract void heat();

    private void updateErrorPos() {
        class_2338 oldErrorPos = this.errorPos;
        this.errorPos = this.multiblock.getLastResult().getPos();
        if (!Objects.equals(oldErrorPos, this.errorPos)) {
            TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new StructureErrorPositionPacket(this.field_11867, this.errorPos), (class_1936)this.field_11863, this.field_11867);
        }
    }

    protected void clientTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.errorVisibleFor > 0) {
            --this.errorVisibleFor;
        }
        if (!this.addedDrainListeners) {
            this.addedDrainListeners = true;
            if (this.structure != null) {
                FluidStack fluid;
                this.structure.forEachContained(sPos -> {
                    class_2586 patt8821$temp = level.method_8321((class_2338)sPos);
                    if (patt8821$temp instanceof IDisplayFluidListener) {
                        IDisplayFluidListener listener = (IDisplayFluidListener)patt8821$temp;
                        this.fluidDisplayListeners.add(new WeakReference<IDisplayFluidListener>(listener));
                    }
                });
                if (!this.fluidDisplayListeners.isEmpty() && !(fluid = IDisplayFluidListener.normalizeFluid(this.tank.getFluidInTank(0))).isEmpty()) {
                    this.updateListeners(fluid);
                }
            }
        }
    }

    protected void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (level.field_9236) {
            if (this.errorVisibleFor > 0) {
                --this.errorVisibleFor;
            }
            return;
        }
        if (!state.method_28498((class_2769)ControllerBlock.IN_STRUCTURE)) {
            return;
        }
        if (this.structureUpdateQueued) {
            this.checkStructure();
            this.structureUpdateQueued = false;
        }
        if (this.structure != null && ((Boolean)state.method_11654((class_2769)SmelteryControllerBlock.IN_STRUCTURE)).booleanValue()) {
            if (this.tick == 0) {
                ++this.expandCounter;
                if (this.expandCounter >= 10 && this.structure.getInnerY() < this.multiblock.getMaxHeight()) {
                    this.expandCounter = 0;
                    if (this.multiblock.canExpand(this.structure, level)) {
                        this.updateStructure();
                    } else {
                        this.updateErrorPos();
                    }
                }
            } else if (this.tick % 4 == 0 && !this.multiblock.isInnerBlock(level, this.structure.getNextInsideCheck())) {
                this.updateStructure();
            }
            this.heat();
            if (this.tick % 4 == 3 && this.fluidUpdateQueued) {
                this.fluidUpdateQueued = false;
                this.tank.syncFluids();
            }
        } else if (this.tick == 0) {
            this.updateStructure();
        }
        this.tick = (this.tick + 1) % 20;
    }

    protected void dropItem(class_1799 stack) {
        assert (this.field_11863 != null);
        if (!this.field_11863.field_9236 && !stack.method_7960()) {
            double x = (double)(this.field_11863.field_9229.method_43057() * 0.5f) + 0.25;
            double y = (double)(this.field_11863.field_9229.method_43057() * 0.5f) + 0.25;
            double z = (double)(this.field_11863.field_9229.method_43057() * 0.5f) + 0.25;
            class_2338 pos = this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)ControllerBlock.FACING));
            class_1542 itementity = new class_1542(this.field_11863, (double)pos.method_10263() + x, (double)pos.method_10264() + y, (double)pos.method_10260() + z, stack);
            itementity.method_6988();
            this.field_11863.method_8649((class_1297)itementity);
        }
    }

    @Nonnull
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 direction) {
        return this.meltingInventory;
    }

    public void updateStructure() {
        this.structureUpdateQueued = true;
    }

    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        this.structure = structure;
    }

    protected void checkStructure() {
        boolean formed;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        boolean wasFormed = (Boolean)this.method_11010().method_11654((class_2769)ControllerBlock.IN_STRUCTURE);
        HeatingStructureMultiblock.StructureData oldStructure = this.structure;
        HeatingStructureMultiblock.StructureData newStructure = this.multiblock.detectMultiblock(this.field_11863, this.field_11867, (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481));
        boolean bl = formed = newStructure != null;
        if (formed != wasFormed) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ControllerBlock.IN_STRUCTURE, (Comparable)Boolean.valueOf(formed)));
        }
        if (formed) {
            TinkerNetwork.getInstance().sendToClientsAround((S2CPacket)new StructureUpdatePacket(this.field_11867, newStructure.getMinPos(), newStructure.getMaxPos(), newStructure.getTanks()), (class_1936)this.field_11863, this.field_11867);
            if (this.fluidCapability == null) {
                this.fluidCapability = this.tank;
            }
            newStructure.assignMaster(this, oldStructure);
            this.setStructure(newStructure);
        } else {
            if (this.fluidCapability != null) {
                this.fluidCapability = null;
            }
            if (oldStructure != null) {
                oldStructure.clearMaster(this);
            }
            this.setStructure(null);
        }
        this.updateErrorPos();
        this.expandCounter = 0;
    }

    public void invalidateStructure() {
        if (this.structure != null) {
            this.structure.clearMaster(this);
            this.structure = null;
            this.errorPos = null;
        }
    }

    @Override
    public void notifyChange(IServantLogic servant, class_2338 pos, class_2680 state) {
        if (this.structure == null) {
            return;
        }
        assert (this.field_11863 != null);
        if (this.multiblock.shouldUpdate(this.field_11863, this.structure, pos, state)) {
            this.updateStructure();
        }
    }

    public MultiblockResult getStructureResult() {
        return this.multiblock.getLastResult();
    }

    @Override
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.tank.setFluids(fluids);
    }

    private void updateListeners(FluidStack fluid) {
        Iterator<WeakReference<IDisplayFluidListener>> iterator = this.fluidDisplayListeners.iterator();
        while (iterator.hasNext()) {
            IDisplayFluidListener listener = (IDisplayFluidListener)iterator.next().get();
            if (listener == null) {
                iterator.remove();
                continue;
            }
            listener.notifyDisplayFluidUpdated(fluid);
        }
    }

    private void updateDisplayFluid(FluidStack fluid) {
        if (this.field_11863 != null && this.field_11863.field_9236) {
            fluid = IDisplayFluidListener.normalizeFluid(fluid);
            this.modelData.setData(IDisplayFluidListener.PROPERTY, (Object)fluid);
            class_2680 state = this.method_11010();
            this.field_11863.method_8413(this.field_11867, state, state, 48);
            this.updateListeners(fluid);
        }
    }

    @Override
    public void addDisplayListener(IDisplayFluidListener listener) {
        boolean have = false;
        for (WeakReference<IDisplayFluidListener> existing : this.fluidDisplayListeners) {
            if (existing.get() != listener) continue;
            have = true;
            break;
        }
        if (!have) {
            this.fluidDisplayListeners.add(new WeakReference<IDisplayFluidListener>(listener));
        }
        listener.notifyDisplayFluidUpdated(IDisplayFluidListener.normalizeFluid(this.tank.getFluidInTank(0)));
    }

    @Override
    public void notifyFluidsChanged(ISmelteryTankHandler.FluidChange type, FluidStack fluid) {
        if (type == ISmelteryTankHandler.FluidChange.ORDER_CHANGED) {
            this.updateDisplayFluid(fluid);
        } else {
            this.fluidUpdateQueued = true;
            this.setChangedFast();
        }
    }

    public class_238 getRenderBoundingBox() {
        if (this.structure != null) {
            return this.structure.getBounds();
        }
        if (this.defaultBounds == null) {
            this.defaultBounds = new class_238(this.field_11867, this.field_11867.method_10069(1, 1, 1));
        }
        return this.defaultBounds;
    }

    private boolean canMeltEntities() {
        if (this.fuelModule.hasFuel()) {
            return true;
        }
        return this.fuelModule.findFuel(false) > 0;
    }

    private class_1799 insertIntoInventory(class_1799 stack) {
        try (Transaction t = TransferUtil.getTransaction();){
            long inserted = StorageUtil.tryInsertStacking((Storage)this.meltingInventory, (Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
            t.commit();
            class_1799 class_17992 = ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)((int)((long)stack.method_7947() - inserted)));
            return class_17992;
        }
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
        return new HeatingStructureContainerMenu(id, inv, this);
    }

    public void setStructureSize(class_2338 minPos, class_2338 maxPos, List<class_2338> tanks) {
        this.setStructure(this.multiblock.createClient(minPos, maxPos, tanks));
        this.fuelModule.clearCachedDisplayListeners();
        if (this.structure == null) {
            this.fluidDisplayListeners.clear();
        } else {
            this.fluidDisplayListeners.removeIf(reference -> {
                IDisplayFluidListener listener = (IDisplayFluidListener)reference.get();
                return listener == null || !this.structure.contains(listener.getListenerPos());
            });
        }
    }

    public void setErrorPos(@Nullable class_2338 errorPos) {
        this.errorPos = errorPos;
        if (errorPos != null && this.field_11863 != null) {
            this.errorVisibleFor = 200;
        }
    }

    public boolean isHighlightError() {
        return this.errorVisibleFor > 0;
    }

    protected abstract boolean isDebugItem(class_1799 var1);

    public boolean showDebugBlockBorder(class_1657 player) {
        return this.isDebugItem(player.method_6047()) || this.isDebugItem(player.method_6079()) || this.isDebugItem(player.method_6118(class_1304.field_6169));
    }

    public String getTextureName() {
        return RetexturedHelper.getTextureName((class_2248)this.texture);
    }

    public void updateTexture(String name) {
        class_2248 oldTexture = this.texture;
        this.texture = RetexturedHelper.getBlock((String)name);
        if (oldTexture != this.texture) {
            this.setChangedFast();
            RetexturedHelper.onTextureUpdated((class_2586)this);
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573(TAG_TANK, 10)) {
            this.tank.read(nbt.method_10562(TAG_TANK));
            FluidStack first = this.tank.getFluidInTank(0);
            if (!first.isEmpty()) {
                this.updateDisplayFluid(first);
            }
        }
        if (nbt.method_10573(TAG_INVENTORY, 10)) {
            this.meltingInventory.readFromTag(nbt.method_10562(TAG_INVENTORY));
        }
        if (nbt.method_10573(TAG_STRUCTURE, 10)) {
            this.setStructure(this.multiblock.readFromTag(nbt.method_10562(TAG_STRUCTURE)));
            if (this.structure != null) {
                this.fluidCapability = this.tank;
            }
        }
        if (nbt.method_10573(TAG_ERROR_POS, 10)) {
            this.errorPos = class_2512.method_10691((class_2487)nbt.method_10562(TAG_ERROR_POS));
        }
        this.fuelModule.readFromTag(nbt);
        if (nbt.method_10573("texture", 8)) {
            this.texture = RetexturedHelper.getBlock((String)nbt.method_10558("texture"));
            RetexturedHelper.onTextureUpdated((class_2586)this);
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        if (this.structure != null) {
            compound.method_10566(TAG_STRUCTURE, (class_2520)this.structure.writeToTag());
        }
        this.fuelModule.writeToTag(compound);
    }

    public void saveSynced(class_2487 compound) {
        super.saveSynced(compound);
        compound.method_10566(TAG_TANK, (class_2520)this.tank.write(new class_2487()));
        compound.method_10566(TAG_INVENTORY, (class_2520)this.meltingInventory.writeToTag());
        if (this.texture != class_2246.field_10124) {
            compound.method_10582("texture", this.getTextureName());
        }
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        if (this.structure != null) {
            nbt.method_10566(TAG_STRUCTURE, (class_2520)this.structure.writeClientTag());
        }
        if (this.errorPos != null) {
            nbt.method_10566(TAG_ERROR_POS, (class_2520)class_2512.method_10692((class_2338)this.errorPos));
        }
        return nbt;
    }

    @Nullable
    public static <HAVE extends HeatingStructureBlockEntity, RET extends class_2586> class_5558<RET> getTicker(class_1937 level, class_2591<RET> expected, class_2591<HAVE> have) {
        return BlockEntityHelper.castTicker(expected, have, level.field_9236 ? CLIENT_TICKER : SERVER_TICKER);
    }

    public IModelData getRenderData() {
        return this.modelData;
    }

    @Nullable
    public class_2338 getErrorPos() {
        return this.errorPos;
    }

    @Nullable
    public HeatingStructureMultiblock.StructureData getStructure() {
        return this.structure;
    }

    public SmelteryTank<HeatingStructureBlockEntity> getTank() {
        return this.tank;
    }

    @Override
    @Nullable
    public SlottedStorage<FluidVariant> getFluidCapability() {
        return this.fluidCapability;
    }

    public MeltingModuleInventory getMeltingInventory() {
        return this.meltingInventory;
    }

    public FuelModule getFuelModule() {
        return this.fuelModule;
    }

    @Nonnull
    public class_2248 getTexture() {
        return this.texture;
    }

    public IModelData getModelData() {
        return this.modelData;
    }
}

